<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              piwebsolution.com
 * @since             2.1.73.71
 * @package           Pi_Dcw
 *
 * @wordpress-plugin
 * Plugin Name:       Add to Cart Redirect for WooCommerce
 * Requires Plugins:  woocommerce
 * Plugin URI:        https://www.piwebsolution.com/product/add-to-cart-direct-checkout-for-woocommerce-pro/
 * Description:       WooCommerce single page checkout, lets you show cart and checkout option on single page, that is one page checkout for WooCommerce, along with it you can redirect user directly to checkout as they click add to cart
 * Version:           2.1.73.71
 * Author:            PI Websolution
 * Author URI:        https://www.piwebsolution.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       pi-dcw
 * Domain Path:       /languages
 * WC tested up to: 10.1.2
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

/**
 * Checking Pro version
 */
function pi_dcw_pro_check(){
	if(is_plugin_active( 'add-to-cart-direct-checkout-for-woocommerce-pro/pi-dcw.php')){
		return true;
	}
	return false;
}

if(pi_dcw_pro_check()){    
    add_action( 'admin_notices', function () {
        ?>
        <div class="error notice">
            <p><?php esc_html_e( 'You have pro version of add to cart redirect active please deactivate the pro version first and then activate free version', 'pi-dcw' ); ?></p>
        </div>
        <?php
    } );
    deactivate_plugins(plugin_basename(__FILE__));
    return;
}else{
/** check woocommerce */
if(!is_plugin_active( 'woocommerce/woocommerce.php')){
    
    add_action( 'admin_notices', function () {
        ?>
        <div class="error notice">
            <p><?php esc_html_e( 'Please Install and Activate WooCommerce plugin, without that this plugin cant work', 'pi-dcw' ); ?></p>
        </div>
        <?php
    });
    return;
}

/* buy link and buy price */
define('PI_DCW_BUY_URL', 'https://www.piwebsolution.com/cart/?add-to-cart=1015&variation_id=1824&utm_campaign=direct-checkout&utm_source=website&utm_medium=direct-buy#order_review_heading');
define('PI_DCW_PRICE', '$16');

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'PI_DCW_VERSION', '2.1.73.71' );
define( 'PISOL_DCW_DELETE_SETTING', false );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-pi-dcw-activator.php
 */
function activate_pi_dcw() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-pi-dcw-activator.php';
	Pi_Dcw_Activator::activate();
}

/**
 * Declare compatible with HPOS new order table 
 */
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-pi-dcw-deactivator.php
 */
function deactivate_pi_dcw() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-pi-dcw-deactivator.php';
	Pi_Dcw_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_pi_dcw' );
register_deactivation_hook( __FILE__, 'deactivate_pi_dcw' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-pi-dcw.php';

function pisol_dcw_plugin_link( $links ) {
	$links = array_merge( array(
        '<a href="' . esc_url( admin_url( '/admin.php?page=pi-dcw' ) ) . '">' . __( 'Settings','pi-dcw' ) . '</a>',
        '<a style="color:#0a9a3e; font-weight:bold;" target="_blank" href="' . esc_url(PI_DCW_BUY_URL) . '">' . __( 'Buy PRO Version','pi-dcw' ) . '</a>'
	), $links );
	return $links;
}
add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'pisol_dcw_plugin_link' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_pi_dcw() {

	$plugin = new Pi_Dcw();
	$plugin->run();

}
run_pi_dcw();
}